/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.cloud.clouduser.service.impl;

import com.tp_link.eap.domain.account.Role;
import com.tp_link.eap.domain.cloud.CloudUser;
import com.tp_link.eap.domain.site.Privilege;
import com.tp_link.eap.domain.site.Site;
import com.tp_link.eap.domain.system.Stat;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.cloud.clouduser.model.CloudAccountModel;
import com.tp_link.eap.monitor.cloud.clouduser.model.CloudUserModel;
import com.tp_link.eap.monitor.cloud.clouduser.model.DeviceUserInfoModel;
import com.tp_link.eap.monitor.cloud.clouduser.model.DeviceUserInfoModel$DeviceUserInfo;
import com.tp_link.eap.monitor.cloud.clouduser.repo.CloudUserRepository;
import com.tp_link.eap.monitor.cloud.clouduser.service.a;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.user.service.PrivilegeServiceI;
import com.tp_link.eap.user.service.RoleService;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import net.sf.json.JSONException;
import net.sf.json.JSONObject;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="cloudUserService")
public class CloudUserServiceImpl
extends com.tp_link.eap.i.a.a<CloudUser>
implements a {
    @Autowired
    private com.tp_link.eap.monitor.cloud.device.service.a a;
    @Autowired
    private com.tp_link.eap.monitor.cloud.cloudinterface.a b;
    @Autowired
    private CloudUserRepository c;
    @Autowired
    private RoleService d;
    @Autowired
    private PrivilegeServiceI e;
    @Autowired
    private com.tp_link.eap.monitor.site.service.a f;
    @Autowired
    private com.tp_link.eap.monitor.system.service.a g;
    private final Logger h = LoggerFactory.getLogger(CloudUserServiceImpl.class);
    private static ExecutorService i = null;
    private final int j = 5000;
    private final long k = 90000L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse bindDeviceOwner(ControlType controlType, JSONObject reqObj) {
        if (controlType != ControlType.a && controlType != ControlType.c) {
            return new OperationResponse(ResErrorCode.g);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            if (!this.a.checkCloudAccessEnable()) {
                return new OperationResponse(ResErrorCode.et);
            }
            this.h.debug("Cloud access enabled, continue bind...");
            JSONObject jSONObject = reqObj.optJSONObject("params");
            if (jSONObject == null) {
                return com.tp_link.eap.util.e.aZ;
            }
            CloudAccountModel cloudAccountModel = (CloudAccountModel)com.tp_link.eap.util.a.b.a((String)jSONObject.toString(), CloudAccountModel.class);
            String string = cloudAccountModel.getCloudUserName();
            String string2 = cloudAccountModel.getCloudPassword();
            if (com.tp_link.eap.util.a.e.a((String)string2) || com.tp_link.eap.util.a.e.a((String)string)) {
                return com.tp_link.eap.util.e.aZ;
            }
            String string3 = this.a.getDeviceId();
            com.tp_link.eap.monitor.cloud.a.a.a();
            com.tp_link.eap.monitor.cloud.a.a.h();
            OperationResponse operationResponse = this.e();
            if (!operationResponse.success()) {
                return operationResponse;
            }
            this.h.debug("Trying to bind cloud account");
            CloudUser cloudUser = this.a();
            if (cloudUser == null) {
                this.h.debug("Owner is null, checking device id...");
                if (string3 == null) {
                    if (!l.b()) {
                        this.h.error("Failed to get hardware device ID!");
                        return com.tp_link.eap.util.e.aY;
                    }
                    this.h.debug("Software Controller deviceId is null, trying to apply new deviceId...");
                    OperationResponse operationResponse2 = this.a(string, string2);
                    if (!operationResponse2.success()) {
                        return operationResponse2;
                    }
                    string3 = this.a.getDeviceId();
                }
                return this.a(string, string2, string3);
            }
            this.h.debug("Owner exists, trying to check bind status...");
            if (string3 == null) {
                this.h.error("Device owner exists but device ID is null!");
                this.b();
                if (!l.b()) {
                    this.h.error("Failed to get hardware device ID!");
                    return com.tp_link.eap.util.e.aY;
                }
                this.h.debug("Software Controller deviceId is null, trying to apply new deviceId...");
                OperationResponse operationResponse3 = this.a(string, string2);
                if (!operationResponse3.success()) {
                    return operationResponse3;
                }
                string3 = this.a.getDeviceId();
                return this.a(string, string2, string3);
            }
            OperationResponse operationResponse4 = this.b.b(string3, com.tp_link.eap.monitor.cloud.e.a.d(cloudUser.getAccountIdEncrypted()));
            this.h.debug("Check bind status errorCode is {}, msg is {}", (Object)operationResponse4.getErrorCode(), (Object)operationResponse4.getMsg());
            switch (operationResponse4.getErrorCode()) {
                case 0: {
                    this.h.info("Controller already bound.");
                    return new OperationResponse(ResErrorCode.eG);
                }
                case -20017: 
                case -20003: {
                    this.h.warn("DeviceId doesn't exist!");
                    this.b();
                    if (l.b()) {
                        OperationResponse operationResponse5 = this.a(string, string2);
                        if (!operationResponse5.success()) {
                            return operationResponse5;
                        }
                        string3 = this.a.getDeviceId();
                        this.h.debug("Apply deviceId success.");
                        return this.a(string, string2, string3);
                    }
                    this.h.error("Hardware deviceId doesn't exist!");
                    return com.tp_link.eap.util.e.aY;
                }
                case -20004: {
                    return this.a(string3);
                }
                case -20005: {
                    this.b();
                    return this.a(string, string2, string3);
                }
            }
            return operationResponse4;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse unbindDeviceOwner(ControlType controlType, JSONObject reqObj) {
        if (controlType != ControlType.a && controlType != ControlType.c) {
            return new OperationResponse(ResErrorCode.g);
        }
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            if (!this.a.checkCloudAccessEnable()) {
                return new OperationResponse(ResErrorCode.et);
            }
            CloudUser cloudUser = this.a();
            if (cloudUser == null) {
                return com.tp_link.eap.util.e.bd;
            }
            String string = this.a.getDeviceId();
            if (com.tp_link.eap.util.a.e.a((String)string)) {
                this.b();
                return com.tp_link.eap.util.e.bd;
            }
            com.tp_link.eap.monitor.cloud.a.a.a();
            com.tp_link.eap.monitor.cloud.a.a.h();
            OperationResponse operationResponse = this.b.c(string, com.tp_link.eap.monitor.cloud.e.a.d(cloudUser.getAccountIdEncrypted()));
            if (!operationResponse.success()) {
                switch (operationResponse.getErrorCode()) {
                    case -20017: 
                    case -20003: {
                        this.h.warn("DeviceId doesn't exist!");
                        this.b();
                        return com.tp_link.eap.util.e.bd;
                    }
                    case -20004: {
                        return this.a(string);
                    }
                }
                return operationResponse;
            }
            this.b();
            return operationResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse addCloudUser(ControlType controlType, JSONObject reqObj) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            if (!this.a.checkCloudAccessEnable()) {
                return new OperationResponse(ResErrorCode.et);
            }
            CloudUser cloudUser = this.a();
            if (cloudUser == null) {
                return new OperationResponse(ResErrorCode.ey);
            }
            String string = this.a.getDeviceId();
            if (string == null) {
                this.b();
                return new OperationResponse(ResErrorCode.ev);
            }
            JSONObject jSONObject = reqObj.optJSONObject("params");
            if (jSONObject == null) {
                return com.tp_link.eap.util.e.aZ;
            }
            CloudUserModel cloudUserModel = (CloudUserModel)com.tp_link.eap.util.a.b.a((String)jSONObject.toString(), CloudUserModel.class);
            OperationResponse operationResponse = this.a(cloudUserModel);
            if (!operationResponse.success()) {
                return operationResponse;
            }
            com.tp_link.eap.monitor.cloud.a.a.a();
            com.tp_link.eap.monitor.cloud.a.a.h();
            OperationResponse operationResponse2 = this.b.c(string, cloudUser.getAccountName(), cloudUserModel.getUserAccount());
            if (!operationResponse2.success()) {
                switch (operationResponse2.getErrorCode()) {
                    case -20017: 
                    case -20003: {
                        this.b();
                        this.h.warn("Device ID does not exist!");
                        return operationResponse2;
                    }
                    case -20013: {
                        return operationResponse2;
                    }
                    case -20012: {
                        this.b();
                        return operationResponse2;
                    }
                    case -20005: {
                        this.b();
                        return operationResponse2;
                    }
                    case -20007: {
                        return this.a(string);
                    }
                    case -20006: {
                        return operationResponse2;
                    }
                }
                return operationResponse2;
            }
            HashMap<String, String> hashMap = new HashMap<String, String>();
            if (JSONObject.fromObject((Object)operationResponse2.getResult()).isNullObject()) {
                CloudUser cloudUser2 = this.c.findByAccountName(cloudUserModel.getUserAccount());
                hashMap.put("accountId", cloudUser2.getAccountIdEncrypted());
                return new OperationResponse(ResErrorCode.eM, hashMap);
            }
            String string2 = JSONObject.fromObject((Object)operationResponse2.getResult()).optString("userAccountId");
            String string3 = com.tp_link.eap.monitor.cloud.e.a.c(string2);
            CloudUser cloudUser3 = this.c.findByAccountIdEncrypted(string3);
            if (cloudUser3 == null) {
                cloudUser3 = new CloudUser();
                cloudUser3.setAccountIdEncrypted(string3);
                cloudUser3.setType(Integer.valueOf(1));
                cloudUser3.setLastUpdate(Long.valueOf(System.currentTimeMillis() - 90000L));
                cloudUser3.setAccountName(cloudUserModel.getUserAccount());
                cloudUser3.setRole(this.d.getRoleByName(cloudUserModel.getRoleName()));
                this.a(cloudUser3, cloudUserModel.getSiteKeys());
                this.c.save(cloudUser3);
                hashMap.put("accountId", cloudUser3.getAccountIdEncrypted());
                return new OperationResponse(ResErrorCode.a, hashMap);
            }
            if (cloudUser.getAccountIdEncrypted().equals(string3)) {
                return new OperationResponse(ResErrorCode.eF);
            }
            hashMap.put("accountId", cloudUser3.getAccountIdEncrypted());
            return new OperationResponse(ResErrorCode.eM, hashMap);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse modifyCloudUser(ControlType controlType, JSONObject reqObj) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            if (!this.a.checkCloudAccessEnable()) {
                return new OperationResponse(ResErrorCode.et);
            }
            CloudUser cloudUser = this.a();
            if (cloudUser == null) {
                return new OperationResponse(ResErrorCode.ey);
            }
            String string = this.a.getDeviceId();
            if (string == null) {
                this.b();
                return new OperationResponse(ResErrorCode.ev);
            }
            JSONObject jSONObject = reqObj.optJSONObject("params");
            if (jSONObject == null) {
                return com.tp_link.eap.util.e.aZ;
            }
            CloudUserModel cloudUserModel = (CloudUserModel)com.tp_link.eap.util.a.b.a((String)jSONObject.toString(), CloudUserModel.class);
            OperationResponse operationResponse = this.b(cloudUserModel);
            if (!operationResponse.success()) {
                return operationResponse;
            }
            CloudUser cloudUser2 = this.c.findByAccountIdEncrypted(cloudUserModel.getUserAccountId());
            if (cloudUser2 == null) {
                return new OperationResponse(ResErrorCode.eH);
            }
            if (cloudUser2.getType() == 0) {
                return new OperationResponse(ResErrorCode.eI);
            }
            com.tp_link.eap.monitor.cloud.clouduser.a.a.e(com.tp_link.eap.monitor.cloud.e.a.d(cloudUserModel.getUserAccountId()));
            cloudUser2.setRole(this.d.getRoleByName(cloudUserModel.getRoleName()));
            this.e.deleteUserPrivilege(cloudUser2.getAccountIdEncrypted());
            this.a(cloudUser2, cloudUserModel.getSiteKeys());
            this.c.save(cloudUser2);
            return com.tp_link.eap.util.e.bd;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse deleteCloudUser(ControlType controlType, JSONObject reqObj) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            if (!this.a.checkCloudAccessEnable()) {
                return new OperationResponse(ResErrorCode.et);
            }
            CloudUser cloudUser = this.a();
            if (cloudUser == null) {
                return new OperationResponse(ResErrorCode.ey);
            }
            String string = this.a.getDeviceId();
            if (string == null) {
                this.b();
                return new OperationResponse(ResErrorCode.ev);
            }
            JSONObject jSONObject = reqObj.optJSONObject("params");
            if (jSONObject == null) {
                return com.tp_link.eap.util.e.aZ;
            }
            String string2 = jSONObject.optString("userAccountId");
            if (com.tp_link.eap.util.a.e.a((String)string2)) {
                return com.tp_link.eap.util.e.aZ;
            }
            CloudUser cloudUser2 = this.c.findByAccountIdEncrypted(string2);
            if (cloudUser2 == null) {
                return new OperationResponse(ResErrorCode.eC);
            }
            com.tp_link.eap.monitor.cloud.a.a.a();
            com.tp_link.eap.monitor.cloud.a.a.h();
            OperationResponse operationResponse = this.b.d(string, com.tp_link.eap.monitor.cloud.e.a.d(cloudUser.getAccountIdEncrypted()), com.tp_link.eap.monitor.cloud.e.a.d(string2));
            if (operationResponse.success()) {
                this.e.deleteUserPrivilege(string2);
                this.c.delete(cloudUser2);
                com.tp_link.eap.monitor.cloud.clouduser.a.a.e(com.tp_link.eap.monitor.cloud.e.a.d(string2));
                return com.tp_link.eap.util.e.bd;
            }
            switch (operationResponse.getErrorCode()) {
                case -20017: 
                case -20003: {
                    this.h.warn("DeviceId doesn't exist!");
                    this.b();
                    return operationResponse;
                }
                case -20005: {
                    this.b();
                    return operationResponse;
                }
                case -20009: {
                    return operationResponse;
                }
                case -20007: {
                    return this.a(string);
                }
            }
            return operationResponse;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse getGridCloudUsers(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)JSONObject.toBean((JSONObject)jSONObject, QueryData.class);
        if (com.tp_link.eap.util.a.e.a((String)queryData.getSortName())) {
            queryData.setSortName("type");
            queryData.setSortOrder("asc");
        }
        Grid grid = new Grid(queryData);
        grid.initSearch(queryData.getSearchKey(), new String[]{"accountName"});
        grid.setTotalRows(this.count(grid));
        com.tp_link.eap.monitor.cloud.a.a.a();
        com.tp_link.eap.monitor.cloud.a.a.h();
        ArrayList<CloudUserModel> arrayList = null;
        List list = null;
        Map<String, String> map = com.tp_link.eap.b.b.a.a;
        synchronized (map) {
            list = this.getList(grid);
            if (this.b(list)) {
                grid.setTotalRows(this.count(grid));
                list = this.getList(grid);
            }
        }
        if (list != null && !list.isEmpty()) {
            map = this.c();
            arrayList = new ArrayList<CloudUserModel>();
            for (CloudUser cloudUser : list) {
                CloudUserModel cloudUserModel = new CloudUserModel();
                cloudUserModel.setUserAccountId(cloudUser.getAccountIdEncrypted());
                cloudUserModel.setUserAccount(cloudUser.getAccountName());
                cloudUserModel.setBindingTime(cloudUser.getBindingTime());
                cloudUserModel.setRoleName(cloudUser.getRole().getName());
                cloudUserModel.setType(cloudUser.getType());
                List list2 = this.e.getUserPrivileges(cloudUser.getAccountIdEncrypted());
                ArrayList<String> arrayList2 = new ArrayList<String>();
                if (list2 != null) {
                    for (Privilege privilege : list2) {
                        arrayList2.add(map.get(privilege.getSiteName()));
                    }
                }
                cloudUserModel.setSiteNames(arrayList2);
                arrayList.add(cloudUserModel);
            }
        }
        grid.setData(arrayList);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    @Override
    public OperationResponse getBindingStatus(ControlType controlType, JSONObject reqObj) {
        HashMap<String, Object> hashMap = new HashMap<String, Object>();
        hashMap.put("enable", this.a.checkCloudAccessEnable());
        CloudUser cloudUser = this.getOwner();
        String string = null;
        boolean bl = false;
        if (cloudUser != null) {
            bl = true;
            string = cloudUser.getAccountName();
        }
        hashMap.put("binding", bl);
        hashMap.put("cloudUserName", string);
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public OperationResponse getBindingStatusAnon(ControlType controlType, JSONObject reqObj) {
        Stat stat = this.g.getSystemStat();
        if (null != stat && stat.isConfigured()) {
            this.h.warn("Controller already configured.");
            return new OperationResponse(ResErrorCode.cD);
        }
        return this.getBindingStatus(controlType, reqObj);
    }

    @Override
    public OperationResponse bindDeviceOwnerAnon(ControlType controlType, JSONObject reqObj) {
        Stat stat = this.g.getSystemStat();
        if (null != stat && stat.isConfigured()) {
            this.h.warn("Controller already configured.");
            return new OperationResponse(ResErrorCode.cD);
        }
        return this.bindDeviceOwner(controlType, reqObj);
    }

    @Override
    public OperationResponse unbindDeviceOwnerAnon(ControlType controlType, JSONObject reqObj) {
        Stat stat = this.g.getSystemStat();
        if (null != stat && stat.isConfigured()) {
            this.h.warn("Controller already configured.");
            return new OperationResponse(ResErrorCode.cD);
        }
        return this.unbindDeviceOwner(controlType, reqObj);
    }

    @Override
    public OperationResponse resetBindingAccount() {
        if (l.b()) {
            return new OperationResponse(ResErrorCode.e);
        }
        CloudUser cloudUser = this.getOwner();
        if (cloudUser == null) {
            return com.tp_link.eap.util.e.bd;
        }
        if (this.a.checkCloudAccessEnable()) {
            Thread thread = Thread.currentThread();
            OperationResponse operationResponse = new OperationResponse(ResErrorCode.eJ);
            CloudUserServiceImpl.g().execute(() -> {
                OperationResponse operationResponse2 = this.unbindDeviceOwner(ControlType.a, null);
                operationResponse.setErrorCode(operationResponse2.getErrorCode());
                operationResponse.setMsg(operationResponse2.getMsg());
                operationResponse.setResult(operationResponse2.getResult());
                thread.interrupt();
            });
            try {
                Thread.sleep(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (operationResponse.success()) {
                return com.tp_link.eap.util.e.bd;
            }
        }
        return this.a(com.tp_link.eap.monitor.cloud.e.a.d(cloudUser.getAccountIdEncrypted()), true);
    }

    @Override
    public CloudUser getOwner() {
        return this.a();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public OperationResponse handleBindRequest(String accountId, String cloudUserName, String localUserName, String localPassWord) {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            this.b();
            CloudUser cloudUser = new CloudUser();
            cloudUser.setAccountIdEncrypted(com.tp_link.eap.monitor.cloud.e.a.c(accountId));
            cloudUser.setAccountName(cloudUserName);
            cloudUser.setType(Integer.valueOf(0));
            cloudUser.setRole(this.d.getRoleByName("administrator"));
            cloudUser.setLastUpdate(Long.valueOf(System.currentTimeMillis() - 90000L));
            this.a(cloudUser);
            this.c.save(cloudUser);
            if (!l.b()) {
                CloudUserServiceImpl.g().execute(() -> this.a(accountId, false));
            }
            return com.tp_link.eap.util.e.bd;
        }
    }

    @Override
    public OperationResponse handleUnbindRequest(String deviceId, String cloudUsername, String accountId) {
        this.b();
        return com.tp_link.eap.util.e.bd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void checkBindingStatusFromCloudServer() {
        Object object = com.tp_link.eap.b.b.a.a;
        synchronized (object) {
            OperationResponse operationResponse = this.e();
            if (!operationResponse.success()) {
                return;
            }
            this.h.debug("Beginning to check binding status.");
            String string = this.a.getDeviceId();
            if (string == null) {
                this.h.debug("check binding status: Device ID is null!");
                return;
            }
            CloudUser cloudUser = this.getOwner();
            if (cloudUser == null) {
                this.a(string);
            } else {
                OperationResponse operationResponse2 = this.b.b(string, com.tp_link.eap.monitor.cloud.e.a.d(cloudUser.getAccountIdEncrypted()));
                if (!operationResponse2.success()) {
                    switch (operationResponse2.getErrorCode()) {
                        case -20017: 
                        case -20003: {
                            this.b();
                            this.h.warn("DeviceId doesn't exist!");
                            break;
                        }
                        case -20004: {
                            this.h.debug("Device has been bound with another account, synchronizing bind status.");
                            this.a(string);
                            break;
                        }
                        case -20005: {
                            this.h.debug("Device has been unbound remotely, synchronizing unbind status.");
                            this.b();
                            break;
                        }
                        default: {
                            this.h.warn("check device bind status error: {}, {}", (Object)operationResponse2.getErrorCode(), (Object)operationResponse2.getMsg());
                        }
                    }
                }
            }
        }
        this.h.debug("Finished checking binding status.");
    }

    @Override
    public CloudUser getCloudUserByAccountId(String accountId) {
        return this.c.findByAccountIdEncrypted(com.tp_link.eap.monitor.cloud.e.a.c(accountId));
    }

    @Override
    public void saveCloudUser(CloudUser cloudUser) {
        this.c.save(cloudUser);
    }

    @Override
    public OperationResponse getCloudUserInfo(ControlType controlType, JSONObject reqObj) {
        if (!controlType.equals((Object)ControlType.b) && !controlType.equals((Object)ControlType.d)) {
            this.h.warn("getCurrentCloudUserInfo is only used for remote controller");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = reqObj.optString("cloudUserSessionId");
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            this.h.warn("Failed to find sessionId in getCurrentCloudUserInfo");
            return com.tp_link.eap.util.e.aY;
        }
        String string2 = com.tp_link.eap.monitor.cloud.clouduser.a.a.a(string);
        if (com.tp_link.eap.util.a.e.a((String)string2)) {
            this.h.warn("Failed to find accountId for session {}", (Object)string);
            return com.tp_link.eap.util.e.aY;
        }
        CloudUser cloudUser = this.getCloudUserByAccountId(string2);
        if (cloudUser == null) {
            this.h.warn("Failed to find cloudUser for account {}", (Object)com.tp_link.eap.monitor.cloud.e.a.c(string2));
            return com.tp_link.eap.util.e.aY;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("accountName", cloudUser.getAccountName());
        hashMap.put("roleId", cloudUser.getRole().getId());
        hashMap.put("roleName", cloudUser.getRole().getName());
        return new OperationResponse(ResErrorCode.a, hashMap);
    }

    @Override
    public List<CloudUser> findByLastSite(String lastSite) {
        return this.c.findByLastSite(lastSite);
    }

    @Override
    public ResErrorCode cloudUserProxyLogin(String sessionId, String accountId) {
        if (!this.a.checkCloudAccessEnable()) {
            this.h.warn("Cloud Access is not enable, no need to reconnect");
            return ResErrorCode.et;
        }
        if (!com.tp_link.eap.monitor.cloud.clouduser.a.a.c(sessionId)) {
            this.h.debug("{} already login", (Object)sessionId.substring(0, sessionId.length() > 10 ? 10 : sessionId.length()));
            return ResErrorCode.a;
        }
        CloudUser cloudUser = this.getCloudUserByAccountId(accountId);
        if (cloudUser == null) {
            this.h.warn("Failed to find cloudUser for account {}", (Object)com.tp_link.eap.monitor.cloud.e.a.c(accountId));
            return ResErrorCode.eu;
        }
        if (com.tp_link.eap.util.a.e.a((String)cloudUser.getLastSite())) {
            this.h.warn("lastSite of {} is null", (Object)com.tp_link.eap.monitor.cloud.e.a.c(accountId));
            return ResErrorCode.eB;
        }
        com.tp_link.eap.monitor.cloud.clouduser.a.a.a(sessionId, accountId);
        com.tp_link.eap.monitor.cloud.clouduser.a.a.b(sessionId, cloudUser.getLastSite());
        if (!this.a.checkCloudAccessEnable()) {
            this.h.warn("Cloud Access is not enable, no need to reconnect");
            com.tp_link.eap.monitor.cloud.clouduser.a.a.a();
            return ResErrorCode.et;
        }
        return ResErrorCode.a;
    }

    private CloudUser a() {
        return this.c.findByType(0);
    }

    private OperationResponse a(String string, String string2, String string3) {
        List<Site> list = this.f.getSites();
        if (list == null || list.isEmpty()) {
            this.h.error("Cannot find any site to assign to owner!");
            return new OperationResponse(ResErrorCode.eB);
        }
        OperationResponse operationResponse = l.b() ? this.b.b(string3, string, string2) : this.b.a(string3, string, string2);
        if (!operationResponse.success()) {
            switch (operationResponse.getErrorCode()) {
                case -20004: {
                    return this.a(string3);
                }
                case -20017: {
                    if (l.b()) {
                        OperationResponse operationResponse2 = this.a(string, string2);
                        if (!operationResponse2.success()) {
                            return operationResponse2;
                        }
                        string3 = this.a.getDeviceId();
                        return this.a(string, string2, string3);
                    }
                    this.h.warn("Bind hardware device: Unexpected error {}", (Object)operationResponse.getErrorCode());
                    return com.tp_link.eap.util.e.aY;
                }
            }
            return operationResponse;
        }
        JSONObject jSONObject = JSONObject.fromObject((Object)operationResponse.getResult());
        String string4 = jSONObject.optString("accountId");
        CloudUser cloudUser = new CloudUser();
        cloudUser.setAccountIdEncrypted(com.tp_link.eap.monitor.cloud.e.a.c(string4));
        cloudUser.setAccountName(string);
        cloudUser.setType(Integer.valueOf(0));
        cloudUser.setRole(this.d.getRoleByName("administrator"));
        cloudUser.setLastUpdate(Long.valueOf(System.currentTimeMillis() - 90000L));
        this.a(cloudUser);
        this.c.save(cloudUser);
        if (!l.b()) {
            CloudUserServiceImpl.g().execute(() -> this.a(string4, false));
        }
        this.d();
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse a(String string, boolean bl) {
        JSONObject jSONObject;
        String string2;
        if (string == null) {
            this.h.warn("Cloud account id to be persisted is null, operation failed!");
            return new OperationResponse(ResErrorCode.d, "Cloud account is null.", null);
        }
        OperationResponse operationResponse = com.tp_link.eap.monitor.cloud.e.a.a();
        if (operationResponse.success()) {
            string2 = (String)operationResponse.getResult();
            try {
                jSONObject = JSONObject.fromObject((Object)string2);
                String string3 = jSONObject.optString("accountId");
                boolean bl2 = jSONObject.optBoolean("reset");
                if (string3 != null && string3.equals(string) && bl == bl2) {
                    this.h.info("Reset flag already exists.");
                    return com.tp_link.eap.util.e.bd;
                }
            }
            catch (JSONException jSONException) {
                this.h.error("Resolve reset data failed.");
                com.tp_link.eap.monitor.cloud.e.a.b();
            }
        }
        string2 = new JSONObject();
        string2.put((Object)"accountId", (Object)com.tp_link.eap.monitor.cloud.e.a.a(string));
        string2.put((Object)"reset", (Object)bl);
        jSONObject = com.tp_link.eap.monitor.cloud.e.a.e(string2.toString());
        if (!jSONObject.success()) {
            this.h.error("Save accountId failed, msg is {}", (Object)jSONObject.getMsg());
        }
        return jSONObject;
    }

    private OperationResponse a(CloudUser cloudUser) {
        if (cloudUser == null) {
            return com.tp_link.eap.util.e.aZ;
        }
        String string = cloudUser.getAccountIdEncrypted();
        Role role = this.d.getRoleByName("administrator");
        List<Site> list = this.f.getSites();
        if (list == null || list.isEmpty()) {
            this.h.error("Cannot find any site to assign to owner!");
            return new OperationResponse(ResErrorCode.eB);
        }
        this.e.deleteUserPrivilege(string);
        for (Site site : list) {
            String string2 = site.getSiteName();
            this.e.assignSiteToUser(string, string2, role);
            if (site.isSystemDefault()) {
                cloudUser.setLastSite(string2);
            }
            this.h.debug("Assign site {} to cloud user {}.", (Object)string2, (Object)string);
        }
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse a(String string, String string2) {
        if (!l.b()) {
            return com.tp_link.eap.util.e.aY;
        }
        OperationResponse operationResponse = this.b.a(string, string2);
        if (!operationResponse.success()) {
            this.h.debug("Apply deviceId failed, errorCode is {}, msg is {}", (Object)operationResponse.getErrorCode(), (Object)operationResponse.getMsg());
            return operationResponse;
        }
        JSONObject jSONObject = JSONObject.fromObject((Object)operationResponse.getResult());
        String string3 = jSONObject.optString("deviceId");
        String string4 = jSONObject.optString("validateHost");
        if (!com.tp_link.eap.util.a.e.a((String)string4)) {
            this.a.setValidateHostBeforeBind(string4);
        } else {
            this.h.error("Value of {} is not valid.", (Object)"validateHost");
        }
        this.a.saveDeviceId(string3);
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse a(CloudUser cloudUser, List<String> list) {
        if (cloudUser == null || list == null || list.isEmpty()) {
            return com.tp_link.eap.util.e.aZ;
        }
        for (String string : list) {
            this.h.debug("Assign site {} to cloud user.", (Object)string);
            this.e.assignSiteToUser(cloudUser.getAccountIdEncrypted(), string, cloudUser.getRole());
        }
        cloudUser.setLastSite(list.get(0));
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse a(String string) {
        this.b();
        CloudUser cloudUser = this.c(string);
        if (cloudUser != null) {
            cloudUser.setRole(this.d.getRoleByName("administrator"));
            this.a(cloudUser);
            this.c.save(cloudUser);
            if (!l.b()) {
                CloudUserServiceImpl.g().execute(() -> this.a(com.tp_link.eap.monitor.cloud.e.a.d(cloudUser.getAccountIdEncrypted()), false));
            }
            this.d();
            return new OperationResponse(ResErrorCode.ex);
        }
        return new OperationResponse(ResErrorCode.ew);
    }

    private void b() {
        List list = com.tp_link.eap.util.a.a.a((Iterable)this.c.findAll());
        if (!CollectionUtils.isEmpty((Collection)list)) {
            for (CloudUser cloudUser : list) {
                com.tp_link.eap.monitor.cloud.clouduser.a.a.a();
                this.e.deleteUserPrivilege(cloudUser.getAccountIdEncrypted());
            }
            this.h.debug("Deleting owner and all cloud users.");
            this.c.deleteAll();
        }
        if (!l.b()) {
            com.tp_link.eap.monitor.cloud.e.a.b();
        }
    }

    private OperationResponse b(String string) {
        ArrayList<CloudUser> arrayList = null;
        OperationResponse operationResponse = this.b.a(string);
        if (operationResponse.success()) {
            DeviceUserInfoModel deviceUserInfoModel = (DeviceUserInfoModel)com.tp_link.eap.util.a.b.a((String)operationResponse.getResult().toString(), DeviceUserInfoModel.class);
            if (deviceUserInfoModel == null || deviceUserInfoModel.getUserList() == null || deviceUserInfoModel.getUserList().isEmpty()) {
                return new OperationResponse(ResErrorCode.a, Collections.emptyList());
            }
            arrayList = new ArrayList<CloudUser>();
            for (DeviceUserInfoModel$DeviceUserInfo deviceUserInfoModel$DeviceUserInfo : deviceUserInfoModel.getUserList()) {
                CloudUser cloudUser = this.a(deviceUserInfoModel$DeviceUserInfo);
                if (cloudUser == null) continue;
                arrayList.add(cloudUser);
            }
            return new OperationResponse(ResErrorCode.a, arrayList);
        }
        this.h.debug("Failed to update cloud user information. errorCode is {}, msg is {}", (Object)operationResponse.getErrorCode(), (Object)operationResponse.getMsg());
        return operationResponse;
    }

    private CloudUser c(String string) {
        OperationResponse operationResponse = this.b(string);
        if (!operationResponse.success()) {
            return null;
        }
        List list = (List)operationResponse.getResult();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (CloudUser cloudUser : list) {
            if (cloudUser.getType() != 0) continue;
            return cloudUser;
        }
        return null;
    }

    private CloudUser a(DeviceUserInfoModel$DeviceUserInfo deviceUserInfoModel$DeviceUserInfo) {
        if (deviceUserInfoModel$DeviceUserInfo == null) {
            return null;
        }
        CloudUser cloudUser = new CloudUser();
        cloudUser.setAccountIdEncrypted(com.tp_link.eap.monitor.cloud.e.a.c(deviceUserInfoModel$DeviceUserInfo.getAccountId()));
        cloudUser.setAccountName(deviceUserInfoModel$DeviceUserInfo.getCloudUserName());
        cloudUser.setNickname(deviceUserInfoModel$DeviceUserInfo.getNickname());
        cloudUser.setType(Integer.valueOf(deviceUserInfoModel$DeviceUserInfo.getRole()));
        cloudUser.setBindingTime(deviceUserInfoModel$DeviceUserInfo.getBindingTime());
        cloudUser.setLastUpdate(Long.valueOf(System.currentTimeMillis()));
        return cloudUser;
    }

    private OperationResponse a(CloudUserModel cloudUserModel) {
        if (cloudUserModel != null && !com.tp_link.eap.util.a.e.a((String)cloudUserModel.getUserAccount())) {
            String string = cloudUserModel.getRoleName();
            if ("administrator".equals(string)) {
                return new OperationResponse(ResErrorCode.eE);
            }
            if ("observer".equals(string) || "operator".equals(string)) {
                List<String> list = cloudUserModel.getSiteKeys();
                if (cloudUserModel.getSiteKeys() == null || cloudUserModel.getSiteKeys().isEmpty()) {
                    return new OperationResponse(ResErrorCode.cl);
                }
                for (String string2 : list) {
                    if (this.f.siteNameAlreadyExist(string2)) continue;
                    return new OperationResponse(ResErrorCode.eA);
                }
                return com.tp_link.eap.util.e.bd;
            }
        }
        return com.tp_link.eap.util.e.aZ;
    }

    private OperationResponse b(CloudUserModel cloudUserModel) {
        if (cloudUserModel != null) {
            String string = cloudUserModel.getRoleName();
            if ("administrator".equals(string)) {
                return new OperationResponse(ResErrorCode.eE);
            }
            if ("observer".equals(string) || "operator".equals(string)) {
                List<String> list = cloudUserModel.getSiteKeys();
                if (cloudUserModel.getSiteKeys() == null || cloudUserModel.getSiteKeys().isEmpty()) {
                    return new OperationResponse(ResErrorCode.cl);
                }
                for (String string2 : list) {
                    if (this.f.siteNameAlreadyExist(string2)) continue;
                    return new OperationResponse(ResErrorCode.eA);
                }
                return com.tp_link.eap.util.e.bd;
            }
        }
        return com.tp_link.eap.util.e.aZ;
    }

    private Map<String, String> c() {
        CloudUser cloudUser = this.a();
        List list = this.e.getUserPrivileges(cloudUser.getAccountIdEncrypted());
        HashMap<String, String> hashMap = new HashMap<String, String>();
        if (list != null) {
            for (Privilege privilege : list) {
                hashMap.put(privilege.getSiteName(), this.f.getSiteBySiteName(privilege.getSiteName()).getName());
            }
        }
        return hashMap;
    }

    public List<CloudUser> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null, null);
    }

    public List<CloudUser> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<CloudUser> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<CloudUser> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        List<CloudUser> list = this.c.getByFilters(queryPage, querySort, filters, searchFilters);
        if (list == null || list.isEmpty()) {
            return null;
        }
        return list;
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.c.getByFilters(null, null, filters, searchFilters).size();
    }

    private void d() {
        if (!this.a.checkCloudAccessEnable()) {
            return;
        }
        String string = this.a.getDeviceId();
        if (com.tp_link.eap.util.a.e.a((String)string)) {
            return;
        }
        OperationResponse operationResponse = this.b(string);
        if (!operationResponse.success()) {
            return;
        }
        this.a((List)operationResponse.getResult());
    }

    private void a(List<CloudUser> list) {
        if (CollectionUtils.isEmpty(list)) {
            this.h.info("Get empty cloud user list from cloud. Deleting all Cloud Users...");
            this.b();
        }
        Iterator iterator = this.c.findAll().iterator();
        HashMap<String, CloudUser> hashMap = new HashMap<String, CloudUser>();
        for (CloudUser object : list) {
            hashMap.put(object.getAccountIdEncrypted(), object);
        }
        while (iterator.hasNext()) {
            CloudUser cloudUser = (CloudUser)iterator.next();
            CloudUser cloudUser2 = (CloudUser)hashMap.get(cloudUser.getAccountIdEncrypted());
            if (cloudUser2 != null) {
                this.h.debug("Updating cloud user...");
                cloudUser.setAccountName(cloudUser2.getAccountName());
                cloudUser.setNickname(cloudUser2.getNickname());
                cloudUser.setBindingTime(cloudUser2.getBindingTime());
                cloudUser.setLastUpdate(Long.valueOf(System.currentTimeMillis()));
                this.c.save(cloudUser);
                hashMap.remove(cloudUser.getAccountIdEncrypted());
                continue;
            }
            if (cloudUser.getType() != 0) {
                this.h.debug("Deleting cloud user...");
                this.c.delete((Serializable)((Object)cloudUser.getAccountIdEncrypted()));
                this.e.deleteUserPrivilege(cloudUser.getAccountIdEncrypted());
                continue;
            }
            this.h.error("Cloud user list doesn't contains owner. List is {}", (Object)ToStringBuilder.reflectionToString(list));
        }
        if (!hashMap.isEmpty()) {
            this.h.warn("Update new cloud users...");
            for (Map.Entry entry : hashMap.entrySet()) {
                CloudUser cloudUser = (CloudUser)entry.getValue();
                cloudUser.setRole(this.d.getRoleByName("observer"));
                List list2 = this.e.getUserPrivileges(cloudUser.getAccountIdEncrypted());
                if (!CollectionUtils.isEmpty((Collection)list2)) {
                    cloudUser.setLastSite(((Privilege)list2.get(0)).getSiteName());
                }
                this.c.save(cloudUser);
            }
        }
    }

    private boolean b(List<CloudUser> list) {
        if (list == null || list.isEmpty()) {
            return false;
        }
        for (CloudUser cloudUser : list) {
            if (cloudUser.getLastUpdate() + 90000L >= System.currentTimeMillis()) continue;
            this.h.debug("Need update cloud users...");
            this.d();
            return true;
        }
        return false;
    }

    private OperationResponse e() {
        if (!l.b()) {
            this.h.info("Check if reset unbind needed to handle.");
            OperationResponse operationResponse = this.f();
            if (operationResponse.success()) {
                JSONObject jSONObject = (JSONObject)operationResponse.getResult();
                String string = com.tp_link.eap.monitor.cloud.e.a.b(jSONObject.getString("accountId"));
                String string2 = this.a.getDeviceId();
                OperationResponse operationResponse2 = this.b.c(string2, string);
                this.h.info("Handle reset unbind errorCode is: {} | msg is: {}", (Object)operationResponse2.getErrorCode(), (Object)operationResponse2.getMsg());
                if (operationResponse2.success()) {
                    this.b();
                    return com.tp_link.eap.util.e.bd;
                }
                switch (operationResponse2.getErrorCode()) {
                    case -20003: {
                        this.h.error("Hardware Controller Device ID not exist!");
                        return operationResponse2;
                    }
                    case -20004: {
                        this.h.info("Device binding another account.");
                        this.a(string2);
                        return com.tp_link.eap.util.e.bd;
                    }
                }
                return operationResponse2;
            }
            this.h.info("Finished reset unbind.");
        }
        return com.tp_link.eap.util.e.bd;
    }

    private OperationResponse f() {
        if (!l.b()) {
            this.h.debug("Check reset: reading private data.");
            OperationResponse operationResponse = com.tp_link.eap.monitor.cloud.e.a.a();
            if (operationResponse.success()) {
                String string = (String)operationResponse.getResult();
                if (!com.tp_link.eap.util.a.e.a((String)string)) {
                    JSONObject jSONObject = null;
                    try {
                        jSONObject = JSONObject.fromObject((Object)string);
                    }
                    catch (JSONException jSONException) {
                        this.h.error("Check reset: resolve data failed.");
                        com.tp_link.eap.monitor.cloud.e.a.b();
                        return com.tp_link.eap.util.e.aY;
                    }
                    if (jSONObject.containsKey((Object)"reset")) {
                        boolean bl = jSONObject.getBoolean("reset");
                        this.h.debug("Reset flag is {}.", (Object)bl);
                        if (bl && jSONObject.containsKey((Object)"accountId")) {
                            return new OperationResponse(ResErrorCode.a, (Object)jSONObject);
                        }
                    }
                } else {
                    this.h.debug("Check reset: private data is empty.");
                }
            } else {
                this.h.error("Check reset: read private data failed, msg is: {}", (Object)operationResponse.getMsg());
            }
        }
        return com.tp_link.eap.util.e.aY;
    }

    private static synchronized ExecutorService g() {
        if (i == null) {
            i = Executors.newSingleThreadExecutor();
        }
        return i;
    }
}

